/* eslint-disable vars-on-top */
/* eslint-disable no-var */
$(document).ready(async function () {
  let listaPesquisaItens = [];
  let ativaBuscaFotosMat = false;
  let ultimoValorConsultado = '';
  let colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));

  if (colunas == null || colunas.vendaMaterial == undefined) {
    localStorage.setItem(
      "colunasInvisiveisRelatorios",
      JSON.stringify({ ...colunas, vendaMaterial: [] })
    );
    colunas = JSON.parse(localStorage.getItem("colunasInvisiveisRelatorios"));
  }


  $('#modalMaterial').on('shown.bs.modal', async function () {
    $('#txtMaterialCampoConsulta').focus();
  });


  $('#modalMaterial').on('show.bs.modal', function () {
    ativaBuscaFotosMat = true;
  });

  $('#modalMaterial').on('hide.bs.modal', function () {
    ativaBuscaFotosMat = false;
  });

  $('#txtMaterialCampoConsulta').on('blur', async function () {
    if ((ultimoValorConsultado != $(this).val()) || (ultimoValorConsultado == '')) {
      await consultaItensMaterial();
    }
  });


  $('#txtMaterialCampoConsulta').on('keydown', async function (e) {
    if (e.currentTarget.value.length > 1) {
      setTimeout(function () {
        $('#txtMaterialCampoConsulta').trigger('blur');
        $('#txtMaterialCampoConsulta').focus();
      }, 500);
    }
  });


  function limpaPesquisaItensMaterial() {
    $("#tabelaMaterial").DataTable().draw(false);
    listaPesquisaItens = [];
  }

  $('#cbMaterialTodosDeposito').on('change', async function () {
    ultimoValorConsultado = '';
    $('#txtMaterialCampoConsulta').trigger('blur');
  });

  $('#cbMaterialContemEstoque').on('change', async function () {
    ultimoValorConsultado = '';
    $('#txtMaterialCampoConsulta').trigger('blur');
  });

  async function consultaItensMaterial() {
    const deposito = pegaChave('#txtDeposito');
    const tabela = pegaChave('#txtTabela');
    const campoFiltro = $('#txtMaterialCampoConsulta').val();
    const somenteComEstoque = $('#cbMaterialContemEstoque').prop('checked');
    const todosDepositos = $('#cbMaterialTodosDeposito').prop('checked');

    try {
      try {
        const pesquisaPorDescricoes = campoFiltro.split('#').length > 1;

        const descricao = pesquisaPorDescricoes ? campoFiltro.split('#')[0] : '';
        const descCor = pesquisaPorDescricoes ? campoFiltro.split('#')[1] : '';
        const descDeposito = pesquisaPorDescricoes ? campoFiltro.split('#')[2] : '';

        const ajaxData = {
          EMPRESA: getCookie('empresa'),
          FILTRO: campoFiltro,
          TABELA: tabela,
          DEPOSITO: deposito,
          SOMENTE_COM_ESTOQUE: somenteComEstoque,
          TODOS_DEPOSITOS: todosDepositos,
          USUARIO: getCookie('cod_usuario'),
          DESCRICAO: descricao,
          DESC_COR: descCor,
          DESC_DEPOSITO: descDeposito
        };

        const colunasDataTable = [
          "CODIGO",
          "DESCRICAO",
          "FOTO",
          "COR",
          "DESC_COR",
          "PRECO",
          "QTDE_EST",
          "QUANTIDADE",
          "BARRA",
          "CODIGO2",
          "ID_MAT_ITEN",
          "QUALIDADE",
          "LOTE",
          "DEPOSITO",
          "DESC_DEPOSITO",
          "DESCRICAO2",
          "REFERENCIA",
          "GRUPO",
          "SUB_GRUPO",
          "TAMANHO",
          "DESC_QUALIDADE",
        ];

        const dataSetCols = [];

        for (let i = 0; i < colunasDataTable.length; i++) {
          dataSetCols.push({
            'title': colunasDataTable[i],
            'data': i
          });
        }

        $('#tabelaMaterial').DataTable({
          paging: true,
          lengthChange: false,
          filter: false,
          info: true,
          order: true,
          pageLength: 100,
          autoWidth: false,
          destroy: true,
          responsive: true,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/vendas/v1/pesquisamaterial`,
            type: "GET",
            headers: {
              'Authorization': BASIC_AUTH
            },
            data: ajaxData,
          },
          "language": {
            "sEmptyTable": "Nenhuma consulta realizada",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhuma consulta realizada",
            "sSearch": "Pesquisa Complementar",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último"
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente"
            }
          },
          columns: dataSetCols,
          columnDefs: [
            //   {
            //   targets: [5, 10],
            //   visible: false,
            //  }, 
            {
              targets: [2],
              render(data, type, row) {
                const codigo = row[0];
                if ((ativaBuscaFotosMat) && (colunasInvisiveis.vendaMaterial.indexOf('2') == -1)) {
                  buscaFotoProduto(codigo, 'M');
                }
                const codigoCriptografado = criptografaCodigo(`img_prod_${codigo}_M`);
                return `<img class="${codigoCriptografado}" src="${BASE_URI}/dist/img/prod-1.png" loading="lazy" alt="${data}" height="30" width="30"/>`;
              }
            },
            {
              targets: [7],
              render(data, type, row, meta) {
                return '<div class="d-flex align-items-center justify-content-center">' +
                  `<input type="number" id="qtdeAdicionarMaterial${meta.row}` +
                  `" class="input-default focus form-control validate inputMaterialQtdeAdicionar mr-2" style="width: 70px" value="0" data-row="${meta.row}"> ` +
                  `<i class="m-0 p-0 fas fa-check adicionaQtdePesquisaMaterial" id="adicionaQtdePesquisaMaterial${meta.row}" style="font-size: 18px"></i>` +
                  '</div>';
              }
            }],
        });

        ultimoValorConsultado = campoFiltro;

        $('select[name="tabelaMaterial_length"]').parent().addClass('d-none');
        $('select[name="tabelaMaterial_length"]').addClass('d-none');

        $("#buttonColVis").on("click", async function () {
          $.LoadingOverlay("show");
          $("#modal-ColunasVisiveis").modal("show");
          $.LoadingOverlay("hide");
        });

        const colunasInvisiveis = JSON.parse(
          localStorage.getItem("colunasInvisiveisRelatorios")
        );

        $("#btnConfirmarColunas").off();
        $("#btnConfirmarColunas").on("click", async function () {
          try {
            $.LoadingOverlay("show");

            const novasColunas = retornaNovasColunasInvisiveis();

            localStorage.setItem(
              "colunasInvisiveisRelatorios",
              JSON.stringify({ ...colunas, vendaMaterial: novasColunas })
            );

            $("#tabelaMaterial").DataTable().columns().visible(true);

            $("#tabelaMaterial")
              .DataTable()
              .columns()
              // eslint-disable-next-line array-callback-return
              .every(function () {
                const colAtual = String(this.dataSrc());
                if (novasColunas.indexOf(colAtual) != -1) {
                  this.visible(false);
                }
              });

          } finally {
            $.LoadingOverlay("hide");
            $("#modal-ColunasVisiveis").modal("hide");
          }
        });

        $("#tabelaMaterial")
          .DataTable()
          .columns()
          // eslint-disable-next-line array-callback-return
          .every(function () {
            const colAtual = String(this.dataSrc());
            if (colunasInvisiveis.vendaMaterial.indexOf(colAtual) != -1) {
              this.visible(false);
            }
          });



      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados dos materiais.');
      }
    } finally {
      //
    }
  }



  $("#modal-ColunasVisiveis").on("show.bs.modal", function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(
      localStorage.getItem("colunasInvisiveisRelatorios")
    );

    $("#tabelaMaterial")
      .DataTable()
      .columns()
      // eslint-disable-next-line array-callback-return
      .every(function () {
        cols.push({
          title: $(this.header()).text(),
          data: this.dataSrc(),
        });
      });
    adicionaColunas(cols, colunasInvisiveis.vendaMaterial ?? [], ['QTDE_EST', 'QUANTIDADE']);
  });


  $("#tabelaMaterial").on("click", ".inputMaterialQtdeAdicionar", function () {
    let that = $(this);
    setTimeout(function () {
      that.select();
    }, 1);
  });

  $("#tabelaMaterial").on("keydown", ".inputMaterialQtdeAdicionar", function (e) {
    const index = +($(this).attr('data-row')) + 1;
    if ((e.key == 'Tab') || (e.key == 'Enter')) {
      $($('.inputMaterialQtdeAdicionar')[index]).focus().click();
    }
  });

  $("#tabelaMaterial").on("click", ".adicionaQtdePesquisaMaterial", async function () {
    const qtdeEstoque = formataNumerico($("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0][6]);
    const item = $("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0];
    if (qtdeEstoque > 0) {
      $(this).siblings(".inputMaterialQtdeAdicionar").val(qtdeEstoque);
      adicionaListaPesquisaItensMaterial(item, qtdeEstoque);
      $($(this).closest("tr")).addClass("selected");
    }
  });



  $('#tabelaMaterial tbody').on('click', 'tr', function (e) {
    const { target } = e;
    const indexRow = $(this)[0].sectionRowIndex;
    if ($(target).is(".adicionaQtdePesquisaMaterial") || $(target).is(".inputMaterialQtdeAdicionar")) {
      return;
    }

    if ($(this).hasClass('selected')) {
      $(this).removeClass('selected');
      $(`#qtdeAdicionarMaterial${indexRow}`).val(0);
    } else {
      const item = $("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0];
      // const qtdeEstoque = formataNumerico(item[6]);
      // $(`#qtdeAdicionarMaterial${indexRow}`).val(qtdeEstoque);
      $(`#qtdeAdicionarMaterial${indexRow}`).click();
      // adicionaListaPesquisaItensMaterial(item, qtdeEstoque);
      // $($(this).closest("tr")).addClass("selected");
    }
  });

  // duplo click faz escolher o registro e fechar a pesquisa
  $('#tabelaMaterial tbody').on('dblclick', 'tr', function (e) {
    const { target } = e;
    const indexRow = $(this)[0].sectionRowIndex;
    if ($(target).is(".adicionaQtdePesquisaMaterial") || $(target).is(".inputMaterialQtdeAdicionar")) {
      return;
    }
    // event.preventDefault();
    const item = $("#tabelaMaterial").DataTable().rows($(this)).data().toArray()[0];
    const qtdeEstoque = formataNumerico(item[6]);
    $(`#qtdeAdicionarMaterial${indexRow}`).val(qtdeEstoque);
    document.firstElementChild.style.zoom = "reset";
    $("#tabelaMaterial").DataTable().$('tr.selected').removeClass('selected');
    $(this).addClass('selected');
    $("#btn_confirmar_material").click();
  });


  $("#tabelaMaterial").on('draw.dt', function () {
    const registros = $("#tabelaMaterial").DataTable().data().toArray();

    listaPesquisaItens.forEach(item => {
      registros.forEach((registro, i) => {
        if (registro[0] == item.codigo
          && registro[3] == item.cor
          && registro[11] == item.qualidade
          && registro[13] == item.deposito
          && registro[12] == item.lote
          && registro[10] == item.id_estoque) {
          $(`#qtdeAdicionarMaterial${i}`).val(item.qtde);
          $($("#tabelaMaterial tbody tr")[i]).addClass("selected");
        }
      });
    });

  });

  $("#tabelaMaterial").on("blur", ".inputMaterialQtdeAdicionar", function () {
    const paramEstoque = parametrosVenda[4];
    const qtdeAtual = formataNumerico($(this).val());
    const qtdeEstoque = formataNumerico($("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0][6]);
    const item = $("#tabelaMaterial").DataTable().rows($(this).closest("tr")).data().toArray()[0];
    if (qtdeAtual > 0) {
      if (paramEstoque != "0" || qtdeAtual <= qtdeEstoque) {
        adicionaListaPesquisaItensMaterial(item, qtdeAtual);
        $($(this).closest("tr")).addClass("selected");
        if (paramEstoque == "1" && qtdeAtual > qtdeEstoque) {
          msgAlerta("Quantidade maior que a disponível no estoque.");
        }
      } else {
        $(this).val(0);
        $($(this).closest("tr").removeClass("selected"));
        msgAlerta("Não é possível selecionar uma quantidade superior à disponível no estoque.");
      }
    } else {
      $(this).val(0);
      $($(this).closest("tr").removeClass("selected"));
    }
  });

  // $("#tabelaMaterial").on("focus", ".inputMaterialQtdeAdicionar", function () {
  //   $(this).val(0);
  // });

  function adicionaListaPesquisaItensMaterial(item, qtde) {

    const itemAtual = {
      codigo: item[0],
      cor: item[3],
      qualidade: item[11],
      lote: item[12],
      deposito: item[13],
      id_estoque: item[10],
      qtde,
      preco: item[5],
      descricao: item[1]
    };

    const indexItem = listaPesquisaItens.findIndex(itemLista => itemAtual.codigo == itemLista.codigo
      && itemAtual.cor == itemLista.cor
      && itemAtual.qualidade == itemLista.qualidade
      && itemAtual.lote == itemLista.lote
      && itemAtual.deposito == itemLista.deposito
      && itemAtual.id_estoque == itemLista.id_estoque
    );
    if (indexItem > -1 && qtde == 0) {
      listaPesquisaItens.splice(indexItem, 1);
    } else if (indexItem > -1) {
      listaPesquisaItens[indexItem].qtde = qtde;
    } else if (indexItem == -1 && qtde > 0) {
      listaPesquisaItens.push(itemAtual);
    }
  }

  // botão selecionar
  $("#btn_confirmar_material").click(async function () {
    $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    async function buscaQualidade(codigo) {
      try {
        const json = await retornaJsonPesquisaPadrao(`{"tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO = '${codigo}'"] }`);
        if (json) {
          return json;
        }
      } catch (error) {
        console.error(error);
      }
    }

    if (listaPesquisaItens.length > 0) {
      listaPesquisaItens.sort(function (a, b) {
        if (a.preco == "" && b.preco != "") {
          return 1;
        } if (a.preco != "" && b.preco == "") {
          return -1;
        }
        return 0;

      });

      for (let i = 0; i < listaPesquisaItens.length; i++) {
        const qualidade = await buscaQualidade(listaPesquisaItens[i].qualidade);
        insereValor("#txtQualidade", qualidade[0].CODIGO, qualidade[0].DESCRICAO);

        $('#txtQuantid').val(listaPesquisaItens[i].qtde);
        $('#txtIdItem').val(listaPesquisaItens[i].id_estoque);
        $('#txtDepositoItem').val(listaPesquisaItens[i].deposito);
        // sempre preencher o id
        // if (listaPesquisaItens[i].lote != '') {
        //   $('#txtCodigo').val(`${listaPesquisaItens[i].qtde}*${listaPesquisaItens[i].lote}`);
        // } else {
        //   $('#txtQuantid').val(listaPesquisaItens[i].qtde);
        //   $('#txtIdItem').val(listaPesquisaItens[i].id_estoque);
        // }
        $("#txtCodigo").attr("informacoesItem", `${listaPesquisaItens[i].codigo} - ${listaPesquisaItens[i].descricao}`);
        $("#txtCodigo").attr("quantidadeItem", listaPesquisaItens[i].qtde);
        $("#txtCodigo").trigger('blur');
        await sleep(500);
        // await RotinaSaidaCodigo('M', '', '', '', true);
      }
    } else {
      const data = $('#tabelaMaterial').dataTable().api().row('.selected').data();
      if (data == undefined) {
        throw msgAlerta("Nenhum item selecionado.");
      }
      const qualidade = await buscaQualidade(data[11]);
      insereValor('#txtQualidade', qualidade[0].CODIGO, qualidade[0].DESCRICAO);
      $("#txtCodigo").attr("informacoesItem", `${data[0]} - ${data[1]}`);
      if ((data[12] != '') && (data[12] != '000000')) {
        $('#txtIdItem').val(data[10]);
        $("#txtCodigo").trigger('blur');
        await sleep(500);
      } else if (data[10] != '') {
        $('#txtIdItem').val(data[10]);
        $('#txtCodigo').val(data[12]);
        $('#txtDepositoItem').val(data[13]);
        $("#txtCodigo").trigger('blur');
        await sleep(500);
      } else {
        $('#txtIdItem').val('');
        $('#txtDepositoItem').val('');
        msgAlerta("O item selecionado não contém Barra, Lote e ID.");
      }
    }
    $("#modalMaterial").modal("hide");
    limpaPesquisaItensMaterial();
    $("#txtCodigo").attr("quantidadeItem", 0);
  });



});